unit ListDLink01;

interface
uses SysUtils, Classes, Dialogs, StdCtrls;

type
   TpLE = ^TLE;
   TLE   = record
   //    (ver. 2.0)
   pNext : TpLE;          //    
   pPrev : TpLE;          //    
   ENum  : cardinal;      //   
   pObj  : pointer;       //   
   pSelf : TpLE;          //    ( )
end;

type TDLst = class(TObject)
  private
    //    (ver. 2.0)
    LEKey   : cardinal;  //    (Inc only)
    LECount : cardinal;  //    
    pHead   : TpLE;      //   
    pTail   : TpLE;      //   
    pCurr   : TpLE;      //   
    //   
    pME1    : TpLE;      //    1
    pME2    : TpLE;      //    2
    //  
    pLE     : TpLE ;     //   
    //  /    
    function  NewLE() : TpLE;
    function  FreeLE (pFreeLE : TpLE) : boolean;
    procedure InsLE  (Cmd   : char; pNewLE : TpLE);
    function  CutLE  (Cmd   : char) : TpLE;
    //  PROPETTY
    function  GetPObj()  : pointer;
    procedure SetPObj(RqPObj : pointer);
  public
    //  
    function  FindLE      (pRqLE : TpLE) : TpLE;
    procedure AddLE       (Cmd : char);
    procedure DelLE       (Cmd : char);
    function  Navigate    (Cmd : char): TpLE;
    procedure FindAndCurr (pRqLE : TpLE);
    function  GetNumLE    (Cmd : char) : cardinal;
    procedure ShowLE      (RqComponent : TComponent;
                           Cmd : char; pRqLE : TpLE); virtual;
    procedure ViewLst     (RqComponent : TComponent);
    //    
    property ptHead : TpLE read pHead;
    property ptTail : TpLE read pTail;
    property ptCurr : TpLE read pCurr;
    property Key    : cardinal read LEKey;
    property Count  : cardinal read LECount;
    property ptObj  : pointer read GetPObj write SetPObj;
end;

implementation


function TDLst.GetPObj()  : pointer;
begin
  Result := 0;
  if pCurr <> nil then Result := pCurr^.pObj;
end;

procedure TDLst.SetPObj(RqPObj : pointer);
begin
  if pCurr <> nil then pCurr^.pObj := RqPObj;
end;

// ---------------------------------------------------------------------------
//    
function TDLst.NewLE() : TpLE;
begin
   Result := nil;
   try
     New(pLE);                         //     
     Fillchar(pLE^, SizeOF(pLE^),#0);  //  
     pLE^.pSelf := pLE;                //   
     Result     := pLE;
   except
     //  
     pLE := nil;
   end;
end;

// ---------------------------------------------------------------------------
//   
function TDLst.FreeLE (pFreeLE : TpLE) : boolean;
begin
   Result := False;
   //    
   if (pFreeLE <> nil) and (pFreeLE^.pSelf = pFreeLE)
   then begin
     try
       Dispose(pFreeLE);   //    
       Result := True;
     except
       //  
     end;
  end;
end;

// ---------------------------------------------------------------------------
//       
function  TDLst.FindLE (pRqLE : TpLE) : TpLE;
begin
   Result := nil;
   if pHead <> nil
   then begin
      pLE := pHead;
      try
         repeat
           if pLE^.pSelf = pRqLE then Result:= pRqLE;
           pLE := pLE^.pNext;
         until (pLE = nil) or (Result <> nil);
      except
         //   
      end;
   end;
end;

// ---------------------------------------------------------------------------
//    
procedure TDLst.InsLE
           ( Cmd     : char;    //  'H' -   head, 'T'  tail 
             pNewLE  : TpLE     //     
           );
begin
 // ,    
 if (pHead = nil) and (pTail = nil)
 then begin
   // INSERT   
   pHead := pNewLE;
   pTail := pNewLE;
 end
 else begin
   // INSERT    
   case UpCase(Cmd) of
   'H': begin
       //      
       pLE := pHead;            //     
       pLE^.pPrev   := pNewLE;  //      
       pNewLE^.pNext := pLE;    //      
       pHead := pNewLE;         //      
       end;
   'T': begin
       //      
       pLE := pTail;            //     
       pLE^.pNext := pNewLE;    //      
       pNewLE^.pPrev := pLE;    //      
       pTail := pNewLE;         //      
       end;
   end; // case
 end;
 Inc(LEKey);                    // +1    
 Inc(LECount);                  // +1     
 pNewLE^.ENum := LEKey;         //    
 pCurr := pNewLE;               //  INSERT   
end;

// ---------------------------------------------------------------------------
//    
function TDLst.CutLE
     ( Cmd      : char          //  'H' -   head, 'T'  tail 
     ) : TpLE;                  //     
begin
 Result := nil;                 //  
 if (pHead <> nil) and (pTail <> nil)
 then begin
   //   
   case UpCase(Cmd) of
   'H': begin  //     
      Result := pHead;          //      
      pLE    := pHead^.pNext;   //     nil
      if (pLE = nil)            // Result    ?
      then pTail := nil
      else pLE^.pPrev := nil;
      pHead := pLE;             //    
   end;
   'T': begin  //     
      Result := pTail;          //      
      pLE    := pTail^.pPrev;   //     nil
      if (pLE = nil)            // Result    ?
      then pHead := nil
      else pLE^.pNext := nil;
      pTail := pLE;             //    
   end;
   end; // case
   pCurr := pLE;                //      
   if (pTail = nil) or (pHead = nil)
   then LECount := 0            //   
   else Dec(LECount);           //     
 end;
end;

// ---------------------------------------------------------------------------
//    
procedure TDLst.AddLE(Cmd : char); //  'H' -   head, 'T'  tail 
begin
  pLE := NewLE();
  //    
  if pLE <> nil
  then InsLE(Cmd, pLE)
  else ShowMessage('      ');
end;

//    
procedure TDLst.DelLE(Cmd : char); //  'H' -   head, 'T'  tail 
begin
  case UpCase(Cmd) of
    'H': pLE := pHead;
    'T': pLE := pTail;
  end;
  if pLE <> nil
  then begin
     if pLE^.pObj = nil
     then begin
        pLE := CutLE(Cmd); //    
        if pLE <> nil then FreeLE(pLE);
     end
     else ShowMessage(' .   ');
  end;
end;

// ---------------------------------------------------------------------------
//   
function TDLst.Navigate (Cmd : char): TpLE;
begin
    Result := nil;
    pLE := pCurr;
    case UpCase(Cmd) of
    'H': Result := pHead;
    'N': if pLE <> nil then Result := pLE^.pNext;
    'P': if pLE <> nil then Result := pLE^.pPrev;
    'T': Result := pTail;
    end;
    if Result <> nil then pCurr := Result;
end;

// ---------------------------------------------------------------------------
//        
procedure TDLst.FindAndCurr (pRqLE : TpLE);
begin
  if pRqLE <> nil
  then begin
     pLE := FindLE(pRqLE);
     if  pLE <> nil then pCurr := pLE;
  end;
end;

// ---------------------------------------------------------------------------
//     ,     
function TDLst.GetNumLE(Cmd : char) : cardinal;
begin
  Result := 0;
  case UpCase(Cmd) of
    'H': pLE := pHead;
    'C': pLE := pCurr;
    'T': pLE := pTail;
  end;
  if pLE <> nil then Result := pLE^.ENum;
end;

// ---------------------------------------------------------------------------
//         
procedure TDLst.ShowLE (RqComponent : TComponent; Cmd : char; pRqLE : TpLE);
begin
  if (RqComponent <> nil)
  then begin
    if RqComponent is TListBox
    then begin
      case UpCase(Cmd) of
      'C' : (RqComponent as TListBox).Clear;
      'A' : begin
              if (pRqLE <> nil)
              then begin
                with (RqComponent as TListBox).Items
                do begin
                  if pRqLE^.pObj = nil
                  then AddObject(IntToStr(pRqLE^.ENum), pointer(pRqLE))
                  else AddObject(IntToStr(pRqLE^.ENum)
                               + ' *', pointer(pRqLE));
                end;
              end;
            end;
      end;
    end;
  end;
end;

// ---------------------------------------------------------------------------
//     
procedure TDLst.ViewLst(RqComponent : TComponent);
begin
  if (RqComponent <> nil)
  then begin
    ShowLE (RqComponent, 'C', nil);
    if (pHead <> nil)
    then begin
       pLE := pHead;
       try
         repeat
           if pLE^.pSelf = pLE
           then begin
               ShowLE (RqComponent, 'A', pLE);
               pLE := pLE^.pNext;
           end;
         until (pLE = nil);
       except
         //   
       end;
    end;
  end;
end;

// ---------------------------------------------------------------------------
end.
